#!/bin/sh

# set -x

BUILD_TMP=../tmp

rm -rf ${BUILD_TMP}
mkdir -p ${BUILD_TMP}

pushd ${BUILD_TMP}

pwd

#
# 	Generate Xcode project for macOS
#
cmake -G Xcode ../.. -DFCM_OS=macOS

rm -rf ../macOS/yuv_mac.xcodeproj
cp -R yuv.xcodeproj ../macOS/yuv_mac.xcodeproj

popd

#
# 	Build release version of library with Xcode
#
CFG=Release
xcodebuild -xcconfig ReleaseOSX.xcconfig -configuration $CFG -project yuv_mac.xcodeproj -sdk macosx

cp ${BUILD_TMP}/$CFG/libyuv.a ../../lib/macOS/libyuv.a

rm -rf ${BUILD_TMP}

echo""
lipo -info ../../lib/macOS/libyuv.a
echo""

